#include <stdio.h>
#include <mpi.h>
#include <malloc.h>
#include <stdlib.h>
#include <string.h>


#define MAX_LOOPS    100000
#define MAX_BUF_SIZE 100000

int  main(int argc, char **argv )
 {
  int myid, numprocs, i, j;
  char name[MPI_MAX_PROCESSOR_NAME];
  int len;
  int left, right;
  void        *r_buf, *s_buf;
  char        err_str[MPI_MAX_ERROR_STRING];
  int         ierr = 0, err_str_len;
  MPI_Status  rcv_stat;
  double      t_start=0.0, t_end=0.0, t=0.0, t_sum=0.0, *table, bandwidth;

  int loops;
  int buf_size;
  int test_type = 0; 



  MPI_Init(&argc, &argv);
  MPI_Comm_size(MPI_COMM_WORLD, &numprocs);
  MPI_Comm_rank(MPI_COMM_WORLD, &myid); 
  MPI_Get_processor_name(name, &len);

  if ( argc < 3 ) {
      if(myid == 0) {
          fprintf(stderr, "Usage: %s loop msg_size test_type\n", argv[0]);
      }
      MPI_Finalize();
      return 0;
  }

  buf_size = atoi(argv[2]);
  loops   = atoi(argv[1]);
  
  if ( argc == 4 )
  {
	test_type = atoi(argv[3]);
	if (  test_type != 1 && test_type !=0 )
	{
		if (myid == 0)
		{
			fprintf(stderr,"Usage: %s loop msg_size test_type\ntest_type should be 0 or 1\nThis test will run with test_type = 0 (default)\n", argv[0]);
		}
		 test_type = 0;
	}
  } 	
		
  if(buf_size > MAX_BUF_SIZE){
      if(myid == 0) {
           fprintf(stderr, "Maximum message size is %d\n", MAX_BUF_SIZE);
      }
      MPI_Finalize();
      return 0;
  }

  if(loops > MAX_LOOPS){
      if(myid == 0) {
           fprintf(stderr, "Maximum number of iterations is %d\n",MAX_LOOPS);
      }
      MPI_Finalize();
      return 0;
  }


  if( (r_buf = (void *)malloc(buf_size)) == NULL )
  {
          fprintf(stderr,"Memory allocation error\n");
          MPI_Abort(MPI_COMM_WORLD, MPI_ERR_INTERN );
          exit(1);
  }

  if( (s_buf = (void *)malloc(buf_size)) == NULL )
  {
          fprintf(stderr,"Memory allocation error\n");
          MPI_Abort(MPI_COMM_WORLD, MPI_ERR_INTERN );
          exit(1);
  }

  if(myid == 0)
  {
    if( (table = (void *)malloc(numprocs*sizeof(*table))) == NULL )
    {
            fprintf(stderr,"Memory allocation error\n");
            MPI_Abort(MPI_COMM_WORLD, MPI_ERR_INTERN );
            exit(1);
    }

    printf("\n************ Running test*************\n");
    printf("Total number of loops per round: %d\n", loops);
    printf("Message size:                    %d\n", buf_size);
    printf("**************************************\n");
    fprintf(stderr, "Round number      ");
  }

  memset(s_buf, 0, buf_size);
  sprintf(s_buf, "From rank %d\n", myid); 
  
  for(i=1; 1; i++)
  {
    right  = myid+i;
    left   = myid-i;

    if(left < 0) 
      left  = numprocs+left;

    if(right >= numprocs) 
      right = right-numprocs;

    MPI_Barrier(MPI_COMM_WORLD);

    if(myid == 0)
    {
      fprintf(stderr, "\b\b\b\b\b%5d", i);
    }

    t_start=MPI_Wtime();
    for( j=0; j < loops; j++)
    {

      ierr = MPI_Sendrecv(s_buf, buf_size, MPI_CHAR, right,  1,
                          r_buf, buf_size, MPI_CHAR, left,   1,
                          MPI_COMM_WORLD, &rcv_stat);

      if( ierr != MPI_SUCCESS)
      {
        MPI_Error_string(ierr, err_str, &err_str_len);
        fprintf(stderr,"%s\n",err_str);
        MPI_Abort(MPI_COMM_WORLD, ierr );
        exit(1);
      }
    }
    t_end=MPI_Wtime();
    t = t_end - t_start;

    t_sum += t;

    
    if( !test_type )
    	break;
 	
    if( abs(left-right) <= 1 || abs(left-right) == (numprocs-1) )
      break;

  }
   if(myid == 0)
   {
    printf("\n**************************************\n");
    fflush(stderr);
   }

   bandwidth = ((buf_size*1.0)/1.0e6)*i*loops*2/t_sum; 

   MPI_Gather(&bandwidth, 1, MPI_DOUBLE, table, 1, MPI_DOUBLE, 0, MPI_COMM_WORLD );

   if(myid == 0)
   {
    
    for( i=0; i<numprocs; i++)
    {
         printf("%-5d - %7.3lf\n", i, table[i]);
    }
  }

  MPI_Finalize();
 }
